// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/common/background_sync_service.mojom
//

package org.chromium.mojom.content;

class BackgroundSyncService_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<BackgroundSyncService, BackgroundSyncService.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<BackgroundSyncService, BackgroundSyncService.Proxy>() {
    
        public String getName() {
            return "content::BackgroundSyncService";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, BackgroundSyncService impl) {
            return new Stub(core, impl);
        }
    
        public BackgroundSyncService[] buildArray(int size) {
          return new BackgroundSyncService[size];
        }
    };

    private static final int REGISTER_ORDINAL = 0;
    private static final int GET_REGISTRATION_ORDINAL = 1;
    private static final int GET_REGISTRATIONS_ORDINAL = 2;
    private static final int UNREGISTER_ORDINAL = 3;
    private static final int GET_PERMISSION_STATUS_ORDINAL = 4;
    private static final int DUPLICATE_REGISTRATION_HANDLE_ORDINAL = 5;
    private static final int RELEASE_REGISTRATION_ORDINAL = 6;
    private static final int NOTIFY_WHEN_DONE_ORDINAL = 7;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements BackgroundSyncService.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void register(SyncRegistration options, long serviceWorkerRegistrationId, boolean requestedFromServiceWorker, RegisterResponse callback) {
            BackgroundSyncServiceRegisterParams _message = new BackgroundSyncServiceRegisterParams();
            _message.options = options;
            _message.serviceWorkerRegistrationId = serviceWorkerRegistrationId;
            _message.requestedFromServiceWorker = requestedFromServiceWorker;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    REGISTER_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundSyncServiceRegisterResponseParamsForwardToCallback(callback));
        }

        @Override
        public void getRegistration(int periodicity, String tag, long serviceWorkerRegistrationId, GetRegistrationResponse callback) {
            BackgroundSyncServiceGetRegistrationParams _message = new BackgroundSyncServiceGetRegistrationParams();
            _message.periodicity = periodicity;
            _message.tag = tag;
            _message.serviceWorkerRegistrationId = serviceWorkerRegistrationId;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_REGISTRATION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundSyncServiceGetRegistrationResponseParamsForwardToCallback(callback));
        }

        @Override
        public void getRegistrations(int periodicity, long serviceWorkerRegistrationId, GetRegistrationsResponse callback) {
            BackgroundSyncServiceGetRegistrationsParams _message = new BackgroundSyncServiceGetRegistrationsParams();
            _message.periodicity = periodicity;
            _message.serviceWorkerRegistrationId = serviceWorkerRegistrationId;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_REGISTRATIONS_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundSyncServiceGetRegistrationsResponseParamsForwardToCallback(callback));
        }

        @Override
        public void unregister(long handleId, long serviceWorkerRegistrationId, UnregisterResponse callback) {
            BackgroundSyncServiceUnregisterParams _message = new BackgroundSyncServiceUnregisterParams();
            _message.handleId = handleId;
            _message.serviceWorkerRegistrationId = serviceWorkerRegistrationId;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    UNREGISTER_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundSyncServiceUnregisterResponseParamsForwardToCallback(callback));
        }

        @Override
        public void getPermissionStatus(int periodicity, long serviceWorkerRegistrationId, GetPermissionStatusResponse callback) {
            BackgroundSyncServiceGetPermissionStatusParams _message = new BackgroundSyncServiceGetPermissionStatusParams();
            _message.periodicity = periodicity;
            _message.serviceWorkerRegistrationId = serviceWorkerRegistrationId;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_PERMISSION_STATUS_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundSyncServiceGetPermissionStatusResponseParamsForwardToCallback(callback));
        }

        @Override
        public void duplicateRegistrationHandle(long handleId, DuplicateRegistrationHandleResponse callback) {
            BackgroundSyncServiceDuplicateRegistrationHandleParams _message = new BackgroundSyncServiceDuplicateRegistrationHandleParams();
            _message.handleId = handleId;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    DUPLICATE_REGISTRATION_HANDLE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundSyncServiceDuplicateRegistrationHandleResponseParamsForwardToCallback(callback));
        }

        @Override
        public void releaseRegistration(long handleId) {
            BackgroundSyncServiceReleaseRegistrationParams _message = new BackgroundSyncServiceReleaseRegistrationParams();
            _message.handleId = handleId;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(RELEASE_REGISTRATION_ORDINAL)));
        }

        @Override
        public void notifyWhenDone(long handleId, NotifyWhenDoneResponse callback) {
            BackgroundSyncServiceNotifyWhenDoneParams _message = new BackgroundSyncServiceNotifyWhenDoneParams();
            _message.handleId = handleId;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    NOTIFY_WHEN_DONE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundSyncServiceNotifyWhenDoneResponseParamsForwardToCallback(callback));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<BackgroundSyncService> {

        Stub(org.chromium.mojo.system.Core core, BackgroundSyncService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                BackgroundSyncService_Internal.MANAGER, messageWithHeader);
                    case RELEASE_REGISTRATION_ORDINAL: {
                        BackgroundSyncServiceReleaseRegistrationParams data =
                                BackgroundSyncServiceReleaseRegistrationParams.deserialize(messageWithHeader.getPayload());
                        getImpl().releaseRegistration(data.handleId);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), BackgroundSyncService_Internal.MANAGER, messageWithHeader, receiver);
                    case REGISTER_ORDINAL: {
                        BackgroundSyncServiceRegisterParams data =
                                BackgroundSyncServiceRegisterParams.deserialize(messageWithHeader.getPayload());
                        getImpl().register(data.options, data.serviceWorkerRegistrationId, data.requestedFromServiceWorker, new BackgroundSyncServiceRegisterResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case GET_REGISTRATION_ORDINAL: {
                        BackgroundSyncServiceGetRegistrationParams data =
                                BackgroundSyncServiceGetRegistrationParams.deserialize(messageWithHeader.getPayload());
                        getImpl().getRegistration(data.periodicity, data.tag, data.serviceWorkerRegistrationId, new BackgroundSyncServiceGetRegistrationResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case GET_REGISTRATIONS_ORDINAL: {
                        BackgroundSyncServiceGetRegistrationsParams data =
                                BackgroundSyncServiceGetRegistrationsParams.deserialize(messageWithHeader.getPayload());
                        getImpl().getRegistrations(data.periodicity, data.serviceWorkerRegistrationId, new BackgroundSyncServiceGetRegistrationsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case UNREGISTER_ORDINAL: {
                        BackgroundSyncServiceUnregisterParams data =
                                BackgroundSyncServiceUnregisterParams.deserialize(messageWithHeader.getPayload());
                        getImpl().unregister(data.handleId, data.serviceWorkerRegistrationId, new BackgroundSyncServiceUnregisterResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case GET_PERMISSION_STATUS_ORDINAL: {
                        BackgroundSyncServiceGetPermissionStatusParams data =
                                BackgroundSyncServiceGetPermissionStatusParams.deserialize(messageWithHeader.getPayload());
                        getImpl().getPermissionStatus(data.periodicity, data.serviceWorkerRegistrationId, new BackgroundSyncServiceGetPermissionStatusResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case DUPLICATE_REGISTRATION_HANDLE_ORDINAL: {
                        BackgroundSyncServiceDuplicateRegistrationHandleParams data =
                                BackgroundSyncServiceDuplicateRegistrationHandleParams.deserialize(messageWithHeader.getPayload());
                        getImpl().duplicateRegistrationHandle(data.handleId, new BackgroundSyncServiceDuplicateRegistrationHandleResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case NOTIFY_WHEN_DONE_ORDINAL: {
                        BackgroundSyncServiceNotifyWhenDoneParams data =
                                BackgroundSyncServiceNotifyWhenDoneParams.deserialize(messageWithHeader.getPayload());
                        getImpl().notifyWhenDone(data.handleId, new BackgroundSyncServiceNotifyWhenDoneResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class BackgroundSyncServiceRegisterParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 32;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public SyncRegistration options;
        public long serviceWorkerRegistrationId;
        public boolean requestedFromServiceWorker;
    
        private BackgroundSyncServiceRegisterParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceRegisterParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceRegisterParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceRegisterParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceRegisterParams result = new BackgroundSyncServiceRegisterParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.options = SyncRegistration.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.serviceWorkerRegistrationId = decoder0.readLong(16);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.requestedFromServiceWorker = decoder0.readBoolean(24, 0);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(options, 8, false);
            encoder0.encode(serviceWorkerRegistrationId, 16);
            encoder0.encode(requestedFromServiceWorker, 24, 0);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceRegisterParams other = (BackgroundSyncServiceRegisterParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.options, other.options))
                return false;
            if (this.serviceWorkerRegistrationId != other.serviceWorkerRegistrationId)
                return false;
            if (this.requestedFromServiceWorker != other.requestedFromServiceWorker)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(options);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(serviceWorkerRegistrationId);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(requestedFromServiceWorker);
            return result;
        }
    }

    static final class BackgroundSyncServiceRegisterResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int err;
        public SyncRegistration options;
    
        private BackgroundSyncServiceRegisterResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceRegisterResponseParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceRegisterResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceRegisterResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceRegisterResponseParams result = new BackgroundSyncServiceRegisterResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.err = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.options = SyncRegistration.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(err, 8);
            encoder0.encode(options, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceRegisterResponseParams other = (BackgroundSyncServiceRegisterResponseParams) object;
            if (this.err != other.err)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.options, other.options))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(err);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(options);
            return result;
        }
    }

    static class BackgroundSyncServiceRegisterResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final BackgroundSyncService.RegisterResponse mCallback;

        BackgroundSyncServiceRegisterResponseParamsForwardToCallback(BackgroundSyncService.RegisterResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(REGISTER_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                BackgroundSyncServiceRegisterResponseParams response = BackgroundSyncServiceRegisterResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.err, response.options);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundSyncServiceRegisterResponseParamsProxyToResponder implements BackgroundSyncService.RegisterResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundSyncServiceRegisterResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer err, SyncRegistration options) {
            BackgroundSyncServiceRegisterResponseParams _response = new BackgroundSyncServiceRegisterResponseParams();
            _response.err = err;
            _response.options = options;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    REGISTER_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class BackgroundSyncServiceGetRegistrationParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 32;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int periodicity;
        public String tag;
        public long serviceWorkerRegistrationId;
    
        private BackgroundSyncServiceGetRegistrationParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceGetRegistrationParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceGetRegistrationParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceGetRegistrationParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceGetRegistrationParams result = new BackgroundSyncServiceGetRegistrationParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.periodicity = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.tag = decoder0.readString(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.serviceWorkerRegistrationId = decoder0.readLong(24);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(periodicity, 8);
            encoder0.encode(tag, 16, false);
            encoder0.encode(serviceWorkerRegistrationId, 24);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceGetRegistrationParams other = (BackgroundSyncServiceGetRegistrationParams) object;
            if (this.periodicity != other.periodicity)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.tag, other.tag))
                return false;
            if (this.serviceWorkerRegistrationId != other.serviceWorkerRegistrationId)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(periodicity);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(tag);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(serviceWorkerRegistrationId);
            return result;
        }
    }

    static final class BackgroundSyncServiceGetRegistrationResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int err;
        public SyncRegistration registration;
    
        private BackgroundSyncServiceGetRegistrationResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceGetRegistrationResponseParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceGetRegistrationResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceGetRegistrationResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceGetRegistrationResponseParams result = new BackgroundSyncServiceGetRegistrationResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.err = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.registration = SyncRegistration.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(err, 8);
            encoder0.encode(registration, 16, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceGetRegistrationResponseParams other = (BackgroundSyncServiceGetRegistrationResponseParams) object;
            if (this.err != other.err)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.registration, other.registration))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(err);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(registration);
            return result;
        }
    }

    static class BackgroundSyncServiceGetRegistrationResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final BackgroundSyncService.GetRegistrationResponse mCallback;

        BackgroundSyncServiceGetRegistrationResponseParamsForwardToCallback(BackgroundSyncService.GetRegistrationResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_REGISTRATION_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                BackgroundSyncServiceGetRegistrationResponseParams response = BackgroundSyncServiceGetRegistrationResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.err, response.registration);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundSyncServiceGetRegistrationResponseParamsProxyToResponder implements BackgroundSyncService.GetRegistrationResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundSyncServiceGetRegistrationResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer err, SyncRegistration registration) {
            BackgroundSyncServiceGetRegistrationResponseParams _response = new BackgroundSyncServiceGetRegistrationResponseParams();
            _response.err = err;
            _response.registration = registration;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_REGISTRATION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class BackgroundSyncServiceGetRegistrationsParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int periodicity;
        public long serviceWorkerRegistrationId;
    
        private BackgroundSyncServiceGetRegistrationsParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceGetRegistrationsParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceGetRegistrationsParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceGetRegistrationsParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceGetRegistrationsParams result = new BackgroundSyncServiceGetRegistrationsParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.periodicity = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.serviceWorkerRegistrationId = decoder0.readLong(16);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(periodicity, 8);
            encoder0.encode(serviceWorkerRegistrationId, 16);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceGetRegistrationsParams other = (BackgroundSyncServiceGetRegistrationsParams) object;
            if (this.periodicity != other.periodicity)
                return false;
            if (this.serviceWorkerRegistrationId != other.serviceWorkerRegistrationId)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(periodicity);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(serviceWorkerRegistrationId);
            return result;
        }
    }

    static final class BackgroundSyncServiceGetRegistrationsResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int err;
        public SyncRegistration[] registrations;
    
        private BackgroundSyncServiceGetRegistrationsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceGetRegistrationsResponseParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceGetRegistrationsResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceGetRegistrationsResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceGetRegistrationsResponseParams result = new BackgroundSyncServiceGetRegistrationsResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.err = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                {
                    org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.registrations = new SyncRegistration[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.registrations[i1] = SyncRegistration.decode(decoder2);
                    }
                }
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(err, 8);
            if (registrations == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(registrations.length, 16, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < registrations.length; ++i0) {
                    encoder1.encode(registrations[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceGetRegistrationsResponseParams other = (BackgroundSyncServiceGetRegistrationsResponseParams) object;
            if (this.err != other.err)
                return false;
            if (!java.util.Arrays.deepEquals(this.registrations, other.registrations))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(err);
            result = prime * result + java.util.Arrays.deepHashCode(registrations);
            return result;
        }
    }

    static class BackgroundSyncServiceGetRegistrationsResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final BackgroundSyncService.GetRegistrationsResponse mCallback;

        BackgroundSyncServiceGetRegistrationsResponseParamsForwardToCallback(BackgroundSyncService.GetRegistrationsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_REGISTRATIONS_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                BackgroundSyncServiceGetRegistrationsResponseParams response = BackgroundSyncServiceGetRegistrationsResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.err, response.registrations);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundSyncServiceGetRegistrationsResponseParamsProxyToResponder implements BackgroundSyncService.GetRegistrationsResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundSyncServiceGetRegistrationsResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer err, SyncRegistration[] registrations) {
            BackgroundSyncServiceGetRegistrationsResponseParams _response = new BackgroundSyncServiceGetRegistrationsResponseParams();
            _response.err = err;
            _response.registrations = registrations;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_REGISTRATIONS_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class BackgroundSyncServiceUnregisterParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public long handleId;
        public long serviceWorkerRegistrationId;
    
        private BackgroundSyncServiceUnregisterParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceUnregisterParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceUnregisterParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceUnregisterParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceUnregisterParams result = new BackgroundSyncServiceUnregisterParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.handleId = decoder0.readLong(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.serviceWorkerRegistrationId = decoder0.readLong(16);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(handleId, 8);
            encoder0.encode(serviceWorkerRegistrationId, 16);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceUnregisterParams other = (BackgroundSyncServiceUnregisterParams) object;
            if (this.handleId != other.handleId)
                return false;
            if (this.serviceWorkerRegistrationId != other.serviceWorkerRegistrationId)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(handleId);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(serviceWorkerRegistrationId);
            return result;
        }
    }

    static final class BackgroundSyncServiceUnregisterResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int err;
    
        private BackgroundSyncServiceUnregisterResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceUnregisterResponseParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceUnregisterResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceUnregisterResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceUnregisterResponseParams result = new BackgroundSyncServiceUnregisterResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.err = decoder0.readInt(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(err, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceUnregisterResponseParams other = (BackgroundSyncServiceUnregisterResponseParams) object;
            if (this.err != other.err)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(err);
            return result;
        }
    }

    static class BackgroundSyncServiceUnregisterResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final BackgroundSyncService.UnregisterResponse mCallback;

        BackgroundSyncServiceUnregisterResponseParamsForwardToCallback(BackgroundSyncService.UnregisterResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(UNREGISTER_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                BackgroundSyncServiceUnregisterResponseParams response = BackgroundSyncServiceUnregisterResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.err);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundSyncServiceUnregisterResponseParamsProxyToResponder implements BackgroundSyncService.UnregisterResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundSyncServiceUnregisterResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer err) {
            BackgroundSyncServiceUnregisterResponseParams _response = new BackgroundSyncServiceUnregisterResponseParams();
            _response.err = err;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    UNREGISTER_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class BackgroundSyncServiceGetPermissionStatusParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int periodicity;
        public long serviceWorkerRegistrationId;
    
        private BackgroundSyncServiceGetPermissionStatusParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceGetPermissionStatusParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceGetPermissionStatusParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceGetPermissionStatusParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceGetPermissionStatusParams result = new BackgroundSyncServiceGetPermissionStatusParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.periodicity = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.serviceWorkerRegistrationId = decoder0.readLong(16);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(periodicity, 8);
            encoder0.encode(serviceWorkerRegistrationId, 16);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceGetPermissionStatusParams other = (BackgroundSyncServiceGetPermissionStatusParams) object;
            if (this.periodicity != other.periodicity)
                return false;
            if (this.serviceWorkerRegistrationId != other.serviceWorkerRegistrationId)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(periodicity);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(serviceWorkerRegistrationId);
            return result;
        }
    }

    static final class BackgroundSyncServiceGetPermissionStatusResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int err;
        public int status;
    
        private BackgroundSyncServiceGetPermissionStatusResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceGetPermissionStatusResponseParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceGetPermissionStatusResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceGetPermissionStatusResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceGetPermissionStatusResponseParams result = new BackgroundSyncServiceGetPermissionStatusResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.err = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.status = decoder0.readInt(12);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(err, 8);
            encoder0.encode(status, 12);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceGetPermissionStatusResponseParams other = (BackgroundSyncServiceGetPermissionStatusResponseParams) object;
            if (this.err != other.err)
                return false;
            if (this.status != other.status)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(err);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(status);
            return result;
        }
    }

    static class BackgroundSyncServiceGetPermissionStatusResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final BackgroundSyncService.GetPermissionStatusResponse mCallback;

        BackgroundSyncServiceGetPermissionStatusResponseParamsForwardToCallback(BackgroundSyncService.GetPermissionStatusResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_PERMISSION_STATUS_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                BackgroundSyncServiceGetPermissionStatusResponseParams response = BackgroundSyncServiceGetPermissionStatusResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.err, response.status);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundSyncServiceGetPermissionStatusResponseParamsProxyToResponder implements BackgroundSyncService.GetPermissionStatusResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundSyncServiceGetPermissionStatusResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer err, Integer status) {
            BackgroundSyncServiceGetPermissionStatusResponseParams _response = new BackgroundSyncServiceGetPermissionStatusResponseParams();
            _response.err = err;
            _response.status = status;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_PERMISSION_STATUS_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class BackgroundSyncServiceDuplicateRegistrationHandleParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public long handleId;
    
        private BackgroundSyncServiceDuplicateRegistrationHandleParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceDuplicateRegistrationHandleParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceDuplicateRegistrationHandleParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceDuplicateRegistrationHandleParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceDuplicateRegistrationHandleParams result = new BackgroundSyncServiceDuplicateRegistrationHandleParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.handleId = decoder0.readLong(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(handleId, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceDuplicateRegistrationHandleParams other = (BackgroundSyncServiceDuplicateRegistrationHandleParams) object;
            if (this.handleId != other.handleId)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(handleId);
            return result;
        }
    }

    static final class BackgroundSyncServiceDuplicateRegistrationHandleResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int err;
        public SyncRegistration registration;
    
        private BackgroundSyncServiceDuplicateRegistrationHandleResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceDuplicateRegistrationHandleResponseParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceDuplicateRegistrationHandleResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceDuplicateRegistrationHandleResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceDuplicateRegistrationHandleResponseParams result = new BackgroundSyncServiceDuplicateRegistrationHandleResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.err = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.registration = SyncRegistration.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(err, 8);
            encoder0.encode(registration, 16, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceDuplicateRegistrationHandleResponseParams other = (BackgroundSyncServiceDuplicateRegistrationHandleResponseParams) object;
            if (this.err != other.err)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.registration, other.registration))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(err);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(registration);
            return result;
        }
    }

    static class BackgroundSyncServiceDuplicateRegistrationHandleResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final BackgroundSyncService.DuplicateRegistrationHandleResponse mCallback;

        BackgroundSyncServiceDuplicateRegistrationHandleResponseParamsForwardToCallback(BackgroundSyncService.DuplicateRegistrationHandleResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DUPLICATE_REGISTRATION_HANDLE_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                BackgroundSyncServiceDuplicateRegistrationHandleResponseParams response = BackgroundSyncServiceDuplicateRegistrationHandleResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.err, response.registration);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundSyncServiceDuplicateRegistrationHandleResponseParamsProxyToResponder implements BackgroundSyncService.DuplicateRegistrationHandleResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundSyncServiceDuplicateRegistrationHandleResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer err, SyncRegistration registration) {
            BackgroundSyncServiceDuplicateRegistrationHandleResponseParams _response = new BackgroundSyncServiceDuplicateRegistrationHandleResponseParams();
            _response.err = err;
            _response.registration = registration;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    DUPLICATE_REGISTRATION_HANDLE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class BackgroundSyncServiceReleaseRegistrationParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public long handleId;
    
        private BackgroundSyncServiceReleaseRegistrationParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceReleaseRegistrationParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceReleaseRegistrationParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceReleaseRegistrationParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceReleaseRegistrationParams result = new BackgroundSyncServiceReleaseRegistrationParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.handleId = decoder0.readLong(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(handleId, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceReleaseRegistrationParams other = (BackgroundSyncServiceReleaseRegistrationParams) object;
            if (this.handleId != other.handleId)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(handleId);
            return result;
        }
    }

    static final class BackgroundSyncServiceNotifyWhenDoneParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public long handleId;
    
        private BackgroundSyncServiceNotifyWhenDoneParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceNotifyWhenDoneParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceNotifyWhenDoneParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceNotifyWhenDoneParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceNotifyWhenDoneParams result = new BackgroundSyncServiceNotifyWhenDoneParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.handleId = decoder0.readLong(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(handleId, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceNotifyWhenDoneParams other = (BackgroundSyncServiceNotifyWhenDoneParams) object;
            if (this.handleId != other.handleId)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(handleId);
            return result;
        }
    }

    static final class BackgroundSyncServiceNotifyWhenDoneResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int err;
        public int finalStatus;
    
        private BackgroundSyncServiceNotifyWhenDoneResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public BackgroundSyncServiceNotifyWhenDoneResponseParams() {
            this(0);
        }
    
        public static BackgroundSyncServiceNotifyWhenDoneResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static BackgroundSyncServiceNotifyWhenDoneResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BackgroundSyncServiceNotifyWhenDoneResponseParams result = new BackgroundSyncServiceNotifyWhenDoneResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.err = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.finalStatus = decoder0.readInt(12);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(err, 8);
            encoder0.encode(finalStatus, 12);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            BackgroundSyncServiceNotifyWhenDoneResponseParams other = (BackgroundSyncServiceNotifyWhenDoneResponseParams) object;
            if (this.err != other.err)
                return false;
            if (this.finalStatus != other.finalStatus)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(err);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(finalStatus);
            return result;
        }
    }

    static class BackgroundSyncServiceNotifyWhenDoneResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final BackgroundSyncService.NotifyWhenDoneResponse mCallback;

        BackgroundSyncServiceNotifyWhenDoneResponseParamsForwardToCallback(BackgroundSyncService.NotifyWhenDoneResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(NOTIFY_WHEN_DONE_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                BackgroundSyncServiceNotifyWhenDoneResponseParams response = BackgroundSyncServiceNotifyWhenDoneResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.err, response.finalStatus);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundSyncServiceNotifyWhenDoneResponseParamsProxyToResponder implements BackgroundSyncService.NotifyWhenDoneResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundSyncServiceNotifyWhenDoneResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer err, Integer finalStatus) {
            BackgroundSyncServiceNotifyWhenDoneResponseParams _response = new BackgroundSyncServiceNotifyWhenDoneResponseParams();
            _response.err = err;
            _response.finalStatus = finalStatus;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    NOTIFY_WHEN_DONE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

}

